# Vespucci 0.9.9 "malenki" Highlights

2017-08-20

This release is dedicated to the memory of Thomas Bellmann "malenki", an engaged OpenStreetMap contributor and Vespucci user.

## End of Android 2.2 / API 8 support

Release 0.9.9 no longer supports Android 2.2. Google has removed 2.2 support from the libraries we use to provide backwards compatible support and there doesn't seem to be a way that we can replace them in any reasonable fashion. Even as is, we cannot use the latest version of these libraries that would match the Android version we are building against.

As Android 2.2 was released in May 2010, nearly 7 years ago, we hope that this change does not affect all too many users.

## Indoor mode

Long pressing the lock icon will cycle through:

 * Normal editing mode
 * Tag only mode
 * Indoor editing mode
   
In indoor mode the displayed level can be changed with the up/down buttons, tapping the level display button will show everything that doesn’t have a level tag (roughly, it is slightly more complicated than that). 
 
## Changed "Geometry Improvement Handle" behaviour
 
Geometry improvement handles on ways now work as they do with iD: 

 * Select way
 * Drag handle (default rendering is a red x)
 * Way remains selected
 * Drag handle
 * .. and so on ...
        
The trade-off is that now more care has to be exercised when dragging ways.
	
## Opening hours editor

On devices with Android 3.1 and later, opening_hours, service_times and collection_times tags can be created and edited with a form interface. Opening hour strings will be auto corrected if possible. The UI for this is still in development, but is already very usable. More information can be found in the source code repositories [OpeningHoursFragment](https://github.com/simonpoole/OpeningHoursFragment)  and [OpeningHoursParser](https://github.com/simonpoole/OpeningHoursParser),
	
## Tag based filter

The filter can be enabled from the normal main menu, the filter can then be changed by tapping the filter icon. More documentation can be found on device or [here](https://github.com/MarcusWolschon/osmeditor4android/blob/master/documentation/docs/help/en/Tag%20filter.md).

## Preset based filter

An alternative to the above, objects are filtered either on individual presets or on preset groups. Tapping on the filter icon will display a preset selection dialog, similar to that used elsewhere in Vespucci. Individual presets can be selected by a normal click, preset groups by a long click (normal click enters the group).

## Scripting

Presets now support a "javascript" property that allows a script to manipulate tags, for example a "check_date" tag can be auto filled with the current date. An [example preset](https://github.com/simonpoole/preset-scripting-examples).  Outside of the use in presets, scripts can be run in an expanded mode via the "JS Console". This is currently of limited usefulness as there is no documentation, however it is intended to add that for future releases.

## Miscellaneous 

 * the "Find" search function now supports Photon based geocoders. The default configuration of the OSMF Nominatim and Komoot's Photon instances can be changed in the advanced preferences.
 * presets support a "deprecated" property that allows them to be matched for the map display and in the form-based tag editor, but they are not offered and found for new use.
 * support for opening a photo viewer in a split window on Android N and later.
 * a lot of work has been done to make it easier to contribute to Vespucci, this includes migrating to the new standard Android project layout, making more operations available via gradle tasks and adding tests for a substantial part of the code.
 * timestamps are now retained on downloaded elements, the value is displayed in the info dialog 
 * a small set of objects (shops, restaurants, etc) are checked for if their last edit or check_date tag is more than 1 year back, if this is the case the object is highlighted and an alert is generated.
 * increased maximum supported zoom so that very small objects can be drawn (please see Known Problems), at the equator the minimum width of the displayed map is now limited to roughly 3 meters compared to the previous 11 meters. 
 * populate most recently used preset list from manually entered tags.
 * the 255 character length limit on tag key, value and relation member role values is now enforced in the editor, previously uploads with such data would fail. 

The full change log is available [here](https://github.com/MarcusWolschon/osmeditor4android/commits/master)

# Known problems

* Due to a change in the way Android N handles URIs that reference on-device files it may not be possible to display photos that are on removable storage. The current workaround of this problem may not work on your device or go away in future Android versions. 
* Some manipulations of very small objects (dimensions roughly 1 meter and smaller), in particular rotation, orthogonalisation and arranging in a circle will possibly not show good results due to the maximum resolution of OSM data which is roughly 1cm at the equator.

# Upgrading from previous versions

* The saved editing state file format has changed, please complete any edits before upgrading.
* For known problems with the beta build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

